// ----------------------------------------------------------------------------------
// Microsoft Developer & Platform Evangelism
// 
// Copyright (c) Microsoft Corporation. All rights reserved.
// 
// THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, 
// EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES 
// OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
// ----------------------------------------------------------------------------------
// The example companies, organizations, products, domain names,
// e-mail addresses, logos, people, places, and events depicted
// herein are fictitious.  No association with any real company,
// organization, product, domain name, email address, logo, person,
// places, or events is intended or should be inferred.
// ----------------------------------------------------------------------------------

namespace SAMLNTService
{
    using System;
    using System.Configuration;
    using System.IdentityModel.Tokens;
    using System.IO;
    using System.Security.Cryptography.X509Certificates;
    using System.ServiceModel;
    using Microsoft.IdentityModel.Protocols.WSFederation.Metadata;
    using Microsoft.IdentityModel.Protocols.WSIdentity;
    using Microsoft.IdentityModel.SecurityTokenService;

    public class FedMetadataService : IFederationMetadataService
    {
        public Stream RequestFederationMetadata()
        {
            string signingCertName = ConfigurationManager.AppSettings["signingCertName"];
            string stsBaseAddress = ConfigurationManager.AppSettings["stsBaseAddress"];
            string stsPath = ConfigurationManager.AppSettings["stsPath"];

            string stsUri = string.Format("https://{0}/{1}", stsBaseAddress, stsPath);

            DisplayClaim claim = new DisplayClaim("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/name");
            
            MetadataSerializer serializer = new MetadataSerializer();
            
            SecurityTokenServiceDescriptor item = new SecurityTokenServiceDescriptor();
            
            EntityDescriptor metadata = new EntityDescriptor();
            
            metadata.EntityId = new EntityId(stsUri);

            X509Certificate2 certificate = CertificateUtil.GetCertificate(StoreName.My, StoreLocation.LocalMachine, signingCertName);
            metadata.SigningCredentials = new X509SigningCredentials(certificate);

            KeyDescriptor descriptor = new KeyDescriptor(new SecurityKeyIdentifier(new SecurityKeyIdentifierClause[] { new X509SecurityToken(certificate).CreateKeyIdentifierClause<X509RawDataKeyIdentifierClause>() }));
            descriptor.Use = KeyType.Signing;
            
            item.Keys.Add(descriptor);

            item.ClaimTypesOffered.Add(claim);

            item.ProtocolsSupported.Add(new Uri("http://docs.oasis-open.org/wsfed/federation/200706"));

            item.SecurityTokenServiceEndpoints.Add(new EndpointAddress(stsUri));
            
            metadata.RoleDescriptors.Add(item);

            MemoryStream stream = new MemoryStream();
            
            serializer.WriteMetadata(stream, metadata);

            stream.Position = 0;

            return stream;
        }
    }
}